<?php

use App\Models\Container;
use App\Services\NginxService;

uses()->group('unit');

beforeEach(function () {
    $this->service = new NginxService();
});

test('nginx config contains app_base_name in logs', function () {
    $container = new Container([
        'name' => 'test',
        'domain' => 'test.example.com',
        'ssl_enabled' => false,
        'port_mappings' => ['8080' => '80'],
    ]);
    
    $config = $this->service->generateConfig($container);
    $baseName = config('panel.base_name');
    
    expect($config)->toContain($baseName);
    expect($config)->toContain('test.example.com');
    expect($config)->toContain('proxy_pass');
});

test('nginx ssl config includes certificate paths', function () {
    $container = new Container([
        'name' => 'test',
        'domain' => 'secure.example.com',
        'ssl_enabled' => true,
        'port_mappings' => ['8443' => '443'],
    ]);
    
    $config = $this->service->generateConfig($container);
    
    expect($config)->toContain('listen 443 ssl');
    expect($config)->toContain('ssl_certificate');
    expect($config)->toContain('letsencrypt');
});

test('upstream name is sanitized', function () {
    $container = new Container([
        'name' => 'my-app_123',
        'domain' => 'test.com',
        'port_mappings' => ['8080' => '80'],
    ]);
    
    $config = $this->service->generateConfig($container);
    $baseName = config('panel.base_name');
    
    expect($config)->toContain("upstream {$baseName}_my_app_123");
});
