<?php

use App\Services\DockerService;

uses()->group('unit');

beforeEach(function () {
    $this->service = new DockerService();
});

test('docker service uses configured socket', function () {
    $socket = config('panel.docker.socket');
    expect($socket)->not->toBeEmpty();
    expect($socket)->toBeString();
});

test('docker network name includes base name', function () {
    $network = config('panel.docker.network');
    $baseName = config('panel.base_name');
    
    expect($network)->toContain($baseName);
});
