<?php

use App\Services\ConfigService;

uses()->group('unit');

beforeEach(function () {
    $this->service = new ConfigService();
});

test('config service validates app definitions', function () {
    $invalid = ['name' => 'Test']]; // Missing slug and image
    
    $result = invade($this->service)->validateDefinition($invalid);
    
    expect($result)->toBeFalse();
});

test('config service accepts valid app definitions', function () {
    $valid = [
        'slug' => 'test-app',
        'name' => 'Test App',
        'image' => 'nginx',
        'tag' => 'latest',
    ];
    
    $result = invade($this->service)->validateDefinition($valid);
    
    expect($result)->toBeTrue();
});

test('invalid slug format is rejected', function () {
    $invalidSlug = [
        'slug' => 'Test App With Spaces!',
        'name' => 'Test',
        'image' => 'nginx',
    ];
    
    $result = invade($this->service)->validateDefinition($invalidSlug);
    
    expect($result)->toBeFalse();
});
