<?php

use App\Models\User;

uses()->group('unit');

test('app_base_name is used throughout configuration', function () {
    $baseName = config('panel.base_name');
    
    expect($baseName)->not->toBeEmpty();
    expect(config('panel.docker.network'))->toContain($baseName);
    expect(config('panel.paths.app'))->toContain($baseName);
    expect(config('panel.paths.config'))->toContain($baseName);
    expect(config('panel.paths.data'))->toContain($baseName);
    expect(config('panel.paths.logs'))->toContain($baseName);
});

test('app_base_name can be changed via environment', function () {
    // This test verifies the app is rebrandable
    $original = config('panel.base_name');
    
    // The key test: changing APP_BASE_NAME should affect all paths
    expect($original)->toBeString();
    expect(strlen($original))->toBeGreaterThan(0);
});
