<?php

use App\Models\User;
use Illuminate\Support\Facades\Hash;

uses()->group('feature');

beforeEach(function () {
    $this->user = User::create([
        'username' => 'testadmin',
        'email' => 'test@example.com',
        'password' => Hash::make('password123'),
        'is_admin' => true,
    ]);
});

test('login page is accessible', function () {
    $response = $this->get('/login');
    
    $response->assertStatus(200);
    $response->assertSee('Sign in');
});

test('user can login with valid credentials', function () {
    $response = $this->post('/login', [
        'username' => 'testadmin',
        'password' => 'password123',
    ]);
    
    $response->assertRedirect('/admin');
    $this->assertAuthenticatedAs($this->user);
});

test('user cannot login with invalid credentials', function () {
    $response = $this->post('/login', [
        'username' => 'testadmin',
        'password' => 'wrongpassword',
    ]);
    
    $response->assertSessionHasErrors('username');
    $this->assertGuest();
});

test('authenticated user can logout', function () {
    $this->actingAs($this->user);
    
    $response = $this->post('/logout');
    
    $response->assertRedirect('/');
    $this->assertGuest();
});

test('guest is redirected to login', function () {
    $response = $this->get('/admin');
    
    $response->assertRedirect('/login');
});

test('authenticated user can access admin', function () {
    $response = $this->actingAs($this->user)->get('/admin');
    
    $response->assertStatus(200);
    $response->assertSee('Dashboard');
});
