<?php

use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\ContainerController;
use App\Http\Controllers\Admin\LibraryController;
use App\Http\Controllers\Auth\LoginController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
*/

// Redirect root to login
Route::get('/', function () {
    return redirect()->route('login');
});

// Authentication Routes
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

// Protected Admin Routes
Route::middleware(['auth'])->prefix('admin')->name('admin.')->group(function () {
    
    // Dashboard
    Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
    
    // Containers
    Route::get('/containers', [ContainerController::class, 'index'])->name('containers.index');
    Route::get('/containers/create', [ContainerController::class, 'create'])->name('containers.create');
    Route::post('/containers', [ContainerController::class, 'store'])->name('containers.store');
    Route::get('/containers/{container}', [ContainerController::class, 'show'])->name('containers.show');
    Route::post('/containers/{container}/start', [ContainerController::class, 'start'])->name('containers.start');
    Route::post('/containers/{container}/stop', [ContainerController::class, 'stop'])->name('containers.stop');
    Route::post('/containers/{container}/restart', [ContainerController::class, 'restart'])->name('containers.restart');
    Route::delete('/containers/{container}', [ContainerController::class, 'destroy'])->name('containers.destroy');
    Route::get('/containers/{container}/logs', [ContainerController::class, 'logs'])->name('containers.logs');
    
    // Library
    Route::get('/library', [LibraryController::class, 'index'])->name('library.index');
    Route::get('/library/create', [LibraryController::class, 'create'])->name('library.create');
    Route::post('/library', [LibraryController::class, 'store'])->name('library.store');
    Route::get('/library/{library}', [LibraryController::class, 'show'])->name('library.show');
    Route::get('/library/{library}/edit', [LibraryController::class, 'edit'])->name('library.edit');
    Route::put('/library/{library}', [LibraryController::class, 'update'])->name('library.update');
    Route::delete('/library/{library}', [LibraryController::class, 'destroy'])->name('library.destroy');
    Route::post('/library/sync', [LibraryController::class, 'sync'])->name('library.sync');
});
