@extends('layouts.app')
@section('title', $definition->name)
@section('page-title', 'App: ' . $definition->name)
@section('content')
<div class="max-w-3xl mx-auto">
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
            <h3 class="text-lg font-medium text-gray-900">{{ $definition->name }}</h3>
            <span class="px-2 py-1 text-xs font-medium rounded-full bg-gray-100 text-gray-800">{{ $definition->category }}</span>
        </div>
        <div class="p-6 space-y-6">
            <p class="text-gray-600">{{ $definition->description }}</p>
            <dl class="grid grid-cols-2 gap-4">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Image</dt>
                    <dd class="mt-1 text-sm text-gray-900 font-mono">{{ $definition->getFullImageName() }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Restart Policy</dt>
                    <dd class="mt-1 text-sm text-gray-900">{{ $definition->restart_policy }}</dd>
                </div>
            </dl>
            @if($definition->ports)
            <div>
                <h4 class="text-sm font-medium text-gray-700 mb-2">Default Ports</h4>
                <div class="bg-gray-50 rounded p-3">
                    @foreach($definition->ports as $host => $container)
                        <span class="inline-flex items-center px-2 py-1 rounded text-xs font-medium bg-gray-200 text-gray-700 mr-2">{{ $host }} &rarr; {{ $container }}</span>
                    @endforeach
                </div>
            </div>
            @endif
            <div class="flex justify-end space-x-3 pt-4 border-t border-gray-200">
                <form method="POST" action="{{ route('admin.library.destroy', $definition) }}" onsubmit="return confirm('Delete this app definition?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="px-4 py-2 text-red-600 hover:text-red-900 text-sm font-medium">Delete</button>
                </form>
                <a href="{{ route('admin.containers.create') }}?app={{ $definition->id }}" class="px-4 py-2 bg-gray-900 text-white rounded-md text-sm font-medium hover:bg-gray-800">Deploy</a>
            </div>
        </div>
    </div>
</div>
@endsection
