@extends('layouts.app')
@section('title', 'App Library')
@section('page-title', 'App Library')
@section('content')
<div class="mb-6 flex justify-between items-center">
    <div class="flex space-x-2">
        <a href="{{ route('admin.library.create') }}" class="inline-flex items-center px-4 py-2 bg-gray-900 text-white text-sm font-medium rounded-md hover:bg-gray-800">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
            Add App
        </a>
        <form method="POST" action="{{ route('admin.library.sync') }}" class="inline">
            @csrf
            <button type="submit" class="inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                Sync from Files
            </button>
        </form>
    </div>
</div>
@foreach($definitions as $category => $apps)
<div class="mb-8">
    <h3 class="text-lg font-medium text-gray-900 mb-4 capitalize">{{ $category }}</h3>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
        @foreach($apps as $app)
        <div class="bg-white rounded-lg shadow p-6 hover:shadow-md transition">
            <div class="flex items-start justify-between">
                <div>
                    <h4 class="text-base font-semibold text-gray-900">{{ $app->name }}</h4>
                    <p class="text-xs text-gray-500 mt-1">{{ $app->image }}:{{ $app->tag }}</p>
                </div>
            </div>
            <p class="text-sm text-gray-600 mt-2 line-clamp-2">{{ $app->description }}</p>
            <div class="mt-4 flex space-x-2">
                <a href="{{ route('admin.containers.create') }}?app={{ $app->id }}" class="flex-1 text-center px-3 py-2 bg-gray-900 text-white text-xs font-medium rounded hover:bg-gray-800">Deploy</a>
                <a href="{{ route('admin.library.show', $app) }}" class="px-3 py-2 border border-gray-300 text-xs font-medium rounded text-gray-700 hover:bg-gray-50">Details</a>
            </div>
        </div>
        @endforeach
    </div>
</div>
@endforeach
@if($definitions->isEmpty())
<div class="bg-white rounded-lg shadow p-8 text-center">
    <p class="text-gray-500">No applications in library. <a href="{{ route('admin.library.create') }}" class="text-gray-900 underline">Add one</a> or run sync.</p>
</div>
@endif
@endsection
