@extends('layouts.app')
@section('title', $container->name)
@section('page-title', 'Container: ' . $container->name)
@section('content')
<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <div class="lg:col-span-2 space-y-6">
        <div class="bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200 flex justify-between items-center">
                <h3 class="text-lg font-medium text-gray-900">Logs</h3>
                <button onclick="refreshLogs()" class="text-sm text-gray-600 hover:text-gray-900">Refresh</button>
            </div>
            <div class="p-0">
                <pre id="logs" class="bg-gray-900 text-gray-100 p-4 text-xs overflow-auto max-h-96 font-mono">{{ $logs ?: 'No logs available' }}</pre>
            </div>
        </div>
    </div>
    <div class="space-y-6">
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Status</h3>
            <dl class="space-y-3">
                <div>
                    <dt class="text-sm font-medium text-gray-500">State</dt>
                    <dd class="mt-1">
                        <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full {{ $container->isRunning() ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                            {{ $container->status }}
                        </span>
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Docker ID</dt>
                    <dd class="mt-1 text-sm text-gray-900 font-mono truncate">{{ $container->docker_container_id ?: 'N/A' }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Domain</dt>
                    <dd class="mt-1 text-sm text-gray-900">{{ $container->domain ?: 'N/A' }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">SSL</dt>
                    <dd class="mt-1 text-sm text-gray-900">{{ $container->ssl_enabled ? 'Enabled' : 'Disabled' }}</dd>
                </div>
            </dl>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Actions</h3>
            <div class="space-y-2">
                @if($container->isRunning())
                    <form method="POST" action="{{ route('admin.containers.stop', $container) }}">
                        @csrf
                        <button type="submit" class="w-full px-4 py-2 bg-yellow-600 text-white rounded-md text-sm font-medium hover:bg-yellow-700">Stop</button>
                    </form>
                    <form method="POST" action="{{ route('admin.containers.restart', $container) }}">
                        @csrf
                        <button type="submit" class="w-full px-4 py-2 bg-blue-600 text-white rounded-md text-sm font-medium hover:bg-blue-700">Restart</button>
                    </form>
                @else
                    <form method="POST" action="{{ route('admin.containers.start', $container) }}">
                        @csrf
                        <button type="submit" class="w-full px-4 py-2 bg-green-600 text-white rounded-md text-sm font-medium hover:bg-green-700">Start</button>
                    </form>
                @endif
                <form method="POST" action="{{ route('admin.containers.destroy', $container) }}" onsubmit="return confirm('Permanently delete this container?')">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="w-full px-4 py-2 bg-red-600 text-white rounded-md text-sm font-medium hover:bg-red-700">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
function refreshLogs() {
    fetch('{{ route('admin.containers.logs', $container) }}')
        .then(r => r.json())
        .then(data => {
            document.getElementById('logs').textContent = data.logs || 'No logs available';
        });
}
setInterval(refreshLogs, 5000);
</script>
@endsection
