@extends('layouts.app')
@section('title', 'Containers')
@section('page-title', 'Containers')
@section('content')
<div class="mb-6 flex justify-between items-center">
    <div class="flex space-x-2">
        <a href="{{ route('admin.containers.create') }}" class="inline-flex items-center px-4 py-2 bg-gray-900 text-white text-sm font-medium rounded-md hover:bg-gray-800">
            <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/></svg>
            Deploy New
        </a>
    </div>
</div>
<div class="bg-white rounded-lg shadow overflow-hidden">
    <table class="min-w-full divide-y divide-gray-200">
        <thead class="bg-gray-50">
            <tr>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Name</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Domain</th>
                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Ports</th>
                <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
            </tr>
        </thead>
        <tbody class="divide-y divide-gray-200">
            @forelse($managedContainers as $container)
            <tr>
                <td class="px-6 py-4 whitespace-nowrap">
                    <a href="{{ route('admin.containers.show', $container) }}" class="text-sm font-medium text-gray-900 hover:text-gray-600">{{ $container->name }}</a>
                </td>
                <td class="px-6 py-4 whitespace-nowrap">
                    <span class="inline-flex px-2 py-1 text-xs font-semibold rounded-full {{ $container->isRunning() ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                        {{ $container->status }}
                    </span>
                </td>
                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $container->domain ?: '-' }}</td>
                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                    @if($container->port_mappings)
                        @foreach($container->port_mappings as $host => $containerPort)
                            {{ $host }}:{{ $containerPort }}@if(!$loop->last), @endif
                        @endforeach
                    @else
                        -
                    @endif
                </td>
                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                    <div class="flex justify-end space-x-2">
                        @if($container->isRunning())
                            <form method="POST" action="{{ route('admin.containers.stop', $container) }}" class="inline">
                                @csrf
                                <button type="submit" class="text-yellow-600 hover:text-yellow-900">Stop</button>
                            </form>
                            <form method="POST" action="{{ route('admin.containers.restart', $container) }}" class="inline">
                                @csrf
                                <button type="submit" class="text-blue-600 hover:text-blue-900">Restart</button>
                            </form>
                        @else
                            <form method="POST" action="{{ route('admin.containers.start', $container) }}" class="inline">
                                @csrf
                                <button type="submit" class="text-green-600 hover:text-green-900">Start</button>
                            </form>
                        @endif
                        <form method="POST" action="{{ route('admin.containers.destroy', $container) }}" class="inline" onsubmit="return confirm('Delete this container?')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-600 hover:text-red-900">Delete</button>
                        </form>
                    </div>
                </td>
            </tr>
            @empty
            <tr>
                <td colspan="5" class="px-6 py-8 text-center text-gray-500">No containers found. <a href="{{ route('admin.containers.create') }}" class="text-gray-900 underline">Deploy one now</a>.</td>
            </tr>
            @endforelse
        </tbody>
    </table>
</div>
@endsection
