@extends('layouts.app')
@section('title', 'Deploy Container')
@section('page-title', 'Deploy New Container')
@section('content')
<div class="max-w-2xl mx-auto">
    <div class="bg-white rounded-lg shadow">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-lg font-medium text-gray-900">Container Configuration</h3>
        </div>
        <form method="POST" action="{{ route('admin.containers.store') }}" class="p-6 space-y-6">
            @csrf
            <div>
                <label for="name" class="block text-sm font-medium text-gray-700">Container Name</label>
                <input type="text" name="name" id="name" required pattern="[a-z0-9-]+"
                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-gray-900 focus:ring-gray-900 sm:text-sm"
                    placeholder="my-app">
                <p class="mt-1 text-xs text-gray-500">Lowercase letters, numbers, and hyphens only.</p>
            </div>
            <div>
                <label for="app_definition_id" class="block text-sm font-medium text-gray-700">Application</label>
                <select name="app_definition_id" id="app_definition_id" required
                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-gray-900 focus:ring-gray-900 sm:text-sm">
                    <option value="">Select an application...</option>
                    @foreach($appDefinitions as $def)
                        <option value="{{ $def->id }}">{{ $def->name }} ({{ $def->image }}:{{ $def->tag }})</option>
                    @endforeach
                </select>
            </div>
            <div>
                <label for="domain" class="block text-sm font-medium text-gray-700">Domain (optional)</label>
                <input type="text" name="domain" id="domain"
                    class="mt-1 block w-full rounded-md border-gray-300 shadow-sm focus:border-gray-900 focus:ring-gray-900 sm:text-sm"
                    placeholder="app.example.com">
            </div>
            <div class="flex items-center space-x-6">
                <label class="flex items-center">
                    <input type="checkbox" name="ssl_enabled" value="1"
                        class="rounded border-gray-300 text-gray-900 focus:ring-gray-900">
                    <span class="ml-2 text-sm text-gray-700">Enable SSL (Let's Encrypt)</span>
                </label>
                <label class="flex items-center">
                    <input type="checkbox" name="auto_start" value="1" checked
                        class="rounded border-gray-300 text-gray-900 focus:ring-gray-900">
                    <span class="ml-2 text-sm text-gray-700">Auto-start on boot</span>
                </label>
            </div>
            <div class="flex justify-end space-x-3 pt-4 border-t border-gray-200">
                <a href="{{ route('admin.containers.index') }}" class="px-4 py-2 border border-gray-300 rounded-md text-sm font-medium text-gray-700 hover:bg-gray-50">Cancel</a>
                <button type="submit" class="px-4 py-2 bg-gray-900 text-white rounded-md text-sm font-medium hover:bg-gray-800">Deploy</button>
            </div>
        </form>
    </div>
</div>
@endsection
