<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        // Create default admin user if specified in environment
        if ($username = env('ADMIN_USERNAME')) {
            User::updateOrCreate(
                ['username' => $username],
                [
                    'email' => env('ADMIN_EMAIL', 'admin@localhost'),
                    'password' => Hash::make(env('ADMIN_PASSWORD', 'changeme')),
                    'is_admin' => true,
                ]
            );
        }
    }
}
