<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('containers', function (Blueprint $table) {
            $table->id();
            $table->string('name')->unique();
            $table->foreignId('app_definition_id')->constrained()->onDelete('cascade');
            $table->string('docker_container_id')->nullable();
            $table->string('status')->default('created');
            $table->string('domain')->nullable()->unique();
            $table->boolean('ssl_enabled')->default(false);
            $table->json('port_mappings')->nullable();
            $table->json('environment')->nullable();
            $table->json('volumes')->nullable();
            $table->boolean('auto_start')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('containers');
    }
};
