<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('app_definitions', function (Blueprint $table) {
            $table->id();
            $table->string('slug')->unique();
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('category')->default('other');
            $table->string('image');
            $table->string('registry')->nullable();
            $table->string('tag')->default('latest');
            $table->json('ports')->nullable();
            $table->json('environment_defaults')->nullable();
            $table->json('volumes')->nullable();
            $table->json('labels')->nullable();
            $table->string('network_mode')->nullable();
            $table->string('restart_policy')->default('unless-stopped');
            $table->boolean('custom_image_allowed')->default(false);
            $table->string('documentation_url')->nullable();
            $table->string('icon')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('app_definitions');
    }
};
