<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Application Base Name
    |--------------------------------------------------------------------------
    |
    | This is the canonical identifier for the entire application. It is used
    | for filesystem paths, systemd services, log directories, and more.
    | Changing this value rebrands the entire application.
    |
    */
    'base_name' => env('APP_BASE_NAME', 'homelab'),

    /*
    |--------------------------------------------------------------------------
    | Docker Configuration
    |--------------------------------------------------------------------------
    */
    'docker' => [
        'socket' => env('DOCKER_SOCKET', '/var/run/docker.sock'),
        'compose_path' => env('DOCKER_COMPOSE_PATH', '/usr/local/bin/docker-compose'),
        'network' => env('DOCKER_NETWORK', env('APP_BASE_NAME', 'homelab').'-network'),
    ],

    /*
    |--------------------------------------------------------------------------
    | Nginx Configuration
    |--------------------------------------------------------------------------
    */
    'nginx' => [
        'sites_path' => env('NGINX_SITES_PATH', '/etc/nginx/sites-available'),
        'enabled_path' => env('NGINX_ENABLED_PATH', '/etc/nginx/sites-enabled'),
        'user' => env('NGINX_USER', 'www-data'),
    ],

    /*
    |--------------------------------------------------------------------------
    | SSL Configuration
    |--------------------------------------------------------------------------
    */
    'ssl' => [
        'email' => env('SSL_EMAIL', 'admin@localhost'),
        'staging' => env('SSL_STAGING', false),
    ],

    /*
    |--------------------------------------------------------------------------
    | System Paths
    |--------------------------------------------------------------------------
    */
    'paths' => [
        'app' => env('APP_PATH', '/opt/'.env('APP_BASE_NAME', 'homelab')),
        'config' => env('CONFIG_PATH', '/etc/'.env('APP_BASE_NAME', 'homelab')),
        'data' => env('DATA_PATH', '/var/lib/'.env('APP_BASE_NAME', 'homelab')),
        'logs' => env('LOG_PATH', '/var/log/'.env('APP_BASE_NAME', 'homelab')),
    ],

    /*
    |--------------------------------------------------------------------------
    | Container Library
    |--------------------------------------------------------------------------
    */
    'library' => [
        'path' => env('CONFIG_PATH', '/etc/'.env('APP_BASE_NAME', 'homelab')).'/library',
    ],
];
