<?php

return [
    'default' => env('FILESYSTEM_DISK', 'local'),

    'disks' => [
        'local' => [
            'driver' => 'local',
            'root' => storage_path('app/private'),
            'serve' => true,
            'throw' => false,
        ],

        'public' => [
            'driver' => 'local',
            'root' => storage_path('app/public'),
            'url' => env('APP_URL').'/storage',
            'visibility' => 'public',
            'throw' => false,
        ],

        'config' => [
            'driver' => 'local',
            'root' => env('CONFIG_PATH', '/etc/homelab'),
            'throw' => false,
        ],

        'data' => [
            'driver' => 'local',
            'root' => env('DATA_PATH', '/var/lib/homelab'),
            'throw' => false,
        ],
    ],

    'links' => [
        public_path('storage') => storage_path('app/public'),
    ],
];
