<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    protected $policies = [
        //
    ];

    public function boot(): void
    {
        // Admin gate
        Gate::define('admin', function ($user) {
            return $user->is_admin === true;
        });

        // Container management gate
        Gate::define('manage-containers', function ($user) {
            return $user->is_admin === true;
        });

        // App library management gate
        Gate::define('manage-library', function ($user) {
            return $user->is_admin === true;
        });
    }
}
