<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Container extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'app_definition_id',
        'docker_container_id',
        'status',
        'domain',
        'ssl_enabled',
        'port_mappings',
        'environment',
        'volumes',
        'auto_start',
    ];

    protected function casts(): array
    {
        return [
            'port_mappings' => 'array',
            'environment' => 'array',
            'volumes' => 'array',
            'ssl_enabled' => 'boolean',
            'auto_start' => 'boolean',
        ];
    }

    public function scopeRunning($query)
    {
        return $query->where('status', 'running');
    }

    public function scopeStopped($query)
    {
        return $query->where('status', 'stopped');
    }

    public function isRunning(): bool
    {
        return $this->status === 'running';
    }

    public function hasSsl(): bool
    {
        return $this->ssl_enabled && !empty($this->domain);
    }
}
