<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppDefinition extends Model
{
    use HasFactory;

    protected $fillable = [
        'slug',
        'name',
        'description',
        'category',
        'image',
        'registry',
        'tag',
        'ports',
        'environment_defaults',
        'volumes',
        'labels',
        'network_mode',
        'restart_policy',
        'custom_image_allowed',
        'documentation_url',
        'icon',
    ];

    protected function casts(): array
    {
        return [
            'ports' => 'array',
            'environment_defaults' => 'array',
            'volumes' => 'array',
            'labels' => 'array',
            'custom_image_allowed' => 'boolean',
        ];
    }

    public function scopeByCategory($query, string $category)
    {
        return $query->where('category', $category);
    }

    public function getFullImageName(): string
    {
        $registry = $this->registry ? rtrim($this->registry, '/') . '/' : '';
        return $registry . $this->image . ':' . $this->tag;
    }

    public function getDefaultPorts(): array
    {
        return $this->ports ?? [];
    }
}
