<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Services\DockerService;

class DashboardController extends Controller
{
    public function __construct(
        protected DockerService $docker
    ) {}

    public function index()
    {
        $stats = [
            'docker_available' => $this->docker->isAvailable(),
            'total_containers' => count($this->docker->listContainers(true)),
            'running_containers' => count($this->docker->listContainers(false)),
        ];

        return view('admin.dashboard', compact('stats'));
    }
}
