<?php

namespace App\Console\Commands;

use App\Services\NginxService;
use Illuminate\Console\Command;
use Symfony\Component\Process\Process;

class SslRenewCheck extends Command
{
    protected $signature = 'ssl:renew-check';
    protected $description = 'Check and renew SSL certificates';

    public function handle(NginxService $nginx): int
    {
        $this->info('Checking SSL certificates...');

        $process = new Process(['certbot', 'renew', '--quiet', '--no-random-sleep-on-renew']);
        $process->setTimeout(300);
        $process->run();

        if ($process->isSuccessful()) {
            $this->info('SSL certificate check completed.');
            
            // Reload nginx to apply any new certificates
            $nginx->reload();
            
            return Command::SUCCESS;
        } else {
            $this->error('SSL certificate renewal failed: ' . $process->getErrorOutput());
            return Command::FAILURE;
        }
    }
}
